
VSN_M2000 =  {
      
		Name 			= 'VSN_M2000',--AG
		DisplayName		= _('M-2000 Mirage'),--AG
        Picture 		= "Mirage_2000-5.png",
        Rate 			= "50",
        Shape			= "VSN_M2000",--AG	
        WorldID			=  WSTYPE_PLACEHOLDER, 
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'VSN_M2000';--AG
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'M-2000C_destr'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'VSN_M2000';--AG
			index       =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "M-2000C_destr";
			file  		= "M-2000C_destr";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	13380,	-- kg  with pilot and nose load, F15
		M_nominal					=	19000,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	30845,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	6103,	-- kg (Internal Fuel Only)
		H_max						=	18300,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.271,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	220,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	61,		-- Take off speed in m/s (for AI)
		V_land						=	71,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,

		nose_gear_pos 							 = {2.9,-1.50, 0.0},		-- nosegear coord
		nose_gear_wheel_diameter				 =  0.274,		-- in m
		nose_gear_amortizer_direct_stroke        =  0.220,  	    -- down from nose_gear_pos !!!
		nose_gear_amortizer_reversal_stroke      = -0.015,		-- up
		nose_gear_amortizer_normal_weight_stroke =  0.1,		-- down from nose_gear_pos

		main_gear_pos 							 = {-1.9,-1.55, 1.75},	-- main gear coords
		main_gear_wheel_diameter				 =  0.457,				-- in m
		main_gear_amortizer_direct_stroke        =  0.21,		-- down from main_gear_pos !!!
		main_gear_amortizer_reversal_stroke      = -0.01, 		-- up
		main_gear_amortizer_normal_weight_stroke =  0.0,				-- down from main_gear_pos

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	12,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	403,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	56.5,	-- wing area in m2
		thrust_sum_max				=	13347,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	21952,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	2.5,	-- Max speed in Mach (for AI)
		range						=	2540,	-- Max range in km (for AI)
		RCS							=	5,		-- Radar Cross Section m2
		Ny_max_e					=	8,		-- Max G (for AI)
		detection_range_max			=	250,
		IR_emission_coeff			=	0.91,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	4,		-- With afterburner
		tand_gear_max				=	3.73,--XX  1.732 FA18 3.73, 
		tanker_type					=	2,-- F14=2/S33=4/M29=0/S27=0/F15=1/F16=1/To=0/F18=2/A10A=1/M29K=4/M2000=2/F4=0/F5=0/
		wing_span					=	9.13,  --XX
		wing_type 					= 	0,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	19.43,
		height						=	5.63,
		crew_size					=	1,    --XX
		engines_count				=	1,    --XX
		wing_tip_pos 				= 	{ -5.0, -0.100, 4.565},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		--launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"VelType", 3}, {"Arg", 38, "to", 0.9, "in", 5.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"VelType", 3}, {"Arg", 38, "to", 0.0, "in", 3.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"Arg", 909, "set", 1.0},},},},},
        },
        ServiceHatches = {
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        CrewLadder = {
            {Transition = {"Dismantle", "Erect"}, Sequence = {
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
                {C = {{"Arg", 91, "set", 1.0}}},
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
            }},
            {Transition = {"Erect", "Dismantle"}, Sequence = {
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
                {C = {{"Arg", 91, "set", 0.0}}},
                {C = {{"PosType", 6}, {"Sleep", "for", 10.0}}},
            }},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
		{
			[1] =
			{
				pos 		=  {-6.900, 0.525, 0.000}, -- nozzle coords
				elevation   =  0, -- AFB cone elevation
				diameter	 = 1.15, -- AFB cone diameter
				exhaust_length_ab   = 9, -- lenght in m
				exhaust_length_ab_K = 0.5, -- AB animation
				smokiness_level = 0.2,
			}, -- end of [1]
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
			ejection_seat_name	= "M-2000C_pilotseat",
			drop_canopy_name	= "M-2000c_canopy",
			pos					= {2.679, 0.512, 0.0, },
			canopy_pos			= {2.739, 0.677, 0.0},
			g_suit 			    =  5
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	2,--su-27=4/mig-29=3/su-33=0/F-15=0/tornado=0/F-117=2
		is_tanker	=	false,
		air_refuel_receptacle_pos 	= {5.436, 1.027, 0.409}, -- refuel coords
		fires_pos = 
		{
			[1] = 	{-3.484, -0.004, -0.149}, -- After maingear, fuselage bottom
			[2] = 	{-2.518,  0.055,  1.216}, -- Wing inner Left
			[3] = 	{-2.518,  0.055, -1.216}, -- Wing inner Right
			[4] = 	{-6.250,  0.525,  0.000}, -- Engine damage big
			[5] = 	{-6.750,  0.525,  0.000}, -- Engine damage small
			[6] = 	{-2.346, -0.448,  0.000}, -- Air intake bottom L
			[7] = 	{ 2.346, -0.448,  0.000}, -- Air intake bottom R
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/VSN_M2000_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	-1,	-1},--0,	1,	0  vorne
				pos = 	{-5.827,  0.835, -0.108},---5.776,	1.4,	-0.422
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	-1,	-1},--0,	1,	0
     			pos = 	{-5.827, -0.835, -0.108},---5.776,	1.4,	0.422
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 128,
chaff 				= {default = 112, increment = 56, chargeSz = 1},
flare 				= {default = 16, increment = 16, chargeSz = 1}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 			= "AN/APG-63",--F15
RWR 			= "Abstract RWR"--F15
},
Countermeasures = {
ECM 			= "AN/ALQ-165"--F15
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns =  {
        gun_mount("DEFA_554", { count = 125 },{muzzle_pos_connector = "GUN_POINT_L", muzzle_pos = {1.389,  0.325, -0.241}}),
		gun_mount("DEFA_554", { count = 125 },{muzzle_pos_connector = "GUN_POINT_R", muzzle_pos = {1.389, -0.325, -0.241}})
        },		 
--2  30-mm-Revolverkanonen DEFA Canon 30 M 550 F4 (M554) mit je 125 Schuss Munition (nur Einsitzer-Varianten Mirage 2000C/-5)

pylons_enumeration = {1, 11, 10, 2, 3, 9, 4, 8, 5, 7, 6},

	Pylons =     {

        pylon(1, 0, -3.086, -0.587, 3.311, {use_full_connector_position=true, connector = "str_pnt_001", arg = 308, arg_value = 0},
            {
                { CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 },
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - red
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - green
		        { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - blue
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - white
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - yellow
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C	
				{CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 }, -- Magic R.550				
            }
        ),
       pylon(2, 0, -1.809, -0.556, 2.333, {use_full_connector_position=true, connector = "str_pnt_002", arg = 309, arg_value = 0},
            {
                { CLSID = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}", arg_value = 0.15 },--SUPER 530F
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },--MICA RF
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },--MICA IR
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C
			    { CLSID	= "{8D399DDA-FF81-4F14-904D-099B34FE7918}", arg_value = 0.15 }, --AIM-7M
				{CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", arg_value = 0.35 }, -- MK-20 Rockeye (Beluga stand-in must change)
				{CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.35 }, -- MK-82
				{CLSID = "{M2KC_02_RPL541}", arg_value = 0.0 }, -- RPL 541 Fuel Tank
            }
        ),
		pylon(3, 0, 1.048000, -0.543000, -0.802000,
            {
  				use_full_connector_position = true,
			},
            {
                --
            }
        ),
        pylon(4, 0,  0.870,  -0.467, 0.779,{use_full_connector_position=true, connector = "str_pnt_003", arg = 310, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C
			    { CLSID	= "{8D399DDA-FF81-4F14-904D-099B34FE7918}", arg_value = 0.15 }, --AIM-7M
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- MK-82
				{CLSID  = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", arg_value = 0.15 }, -- MK-20 Rockeye (Beluga stand-in must change)
				{CLSID  = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", arg_value = 0.15 }, -- GBU-12
            }
        ),
        pylon(5, 0, -3.115, -0.467, 1.080, {use_full_connector_position=true, connector = "str_pnt_004", arg = 311, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C
			    { CLSID	= "{8D399DDA-FF81-4F14-904D-099B34FE7918}", arg_value = 0.15 }, --AIM-7M
			    { CLSID	= "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.15 }, --LAU-61
			    { CLSID	= "{A76344EB-32D2-4532-8FA2-0C1BDC00747E}", arg_value = 0.15 }, --LAU-61*3
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- MK-82
				{CLSID  = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", arg_value = 0.15 }, -- MK-20 Rockeye (Beluga stand-in must change)
            }
        ),
        pylon(6, 0, -1.075, -0.589, 0.000, {use_full_connector_position=true, connector = "str_pnt_005", arg = 312, arg_value = 0},
            {
                {CLSID = "{M2KC_RPL_522}", arg_value = 0.15 }, -- RPL 522 FUEL TANK
				{CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", arg_value = 0.25 }, -- MK-20 Rockeye (Beluga stand-in must change)
				{CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", arg_value = 0.25 }, -- GBU-12
				{CLSID = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}", arg_value = 0.25 }, -- GBU-16
				{CLSID = "{34759BBC-AF1E-4AEE-A581-498FF7A6EBCE}", arg_value = 0.25 }, -- GBU-24
				{ CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - red
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - green
		        { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - blue
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - white
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}",attach_point_position = {-1.8, 0.99 ,0 } }, --Smokewinder - yellow
            }
        ),
        pylon(7, 0, -3.115, -0.467, -1.080, {use_full_connector_position=true, connector = "str_pnt_007", arg = 314, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C
			    { CLSID	= "{8D399DDA-FF81-4F14-904D-099B34FE7918}", arg_value = 0.15 }, --AIM-7M
			    { CLSID	= "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.15 }, --LAU-61
			    { CLSID	= "{A76344EB-32D2-4532-8FA2-0C1BDC00747E}", arg_value = 0.15 }, --LAU-61*3
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- MK-82
				{CLSID  = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", arg_value = 0.15 }, -- MK-20 Rockeye (Beluga stand-in must change)
            }
        ),
        pylon(8, 0,  0.870, -0.467, -0.779,{use_full_connector_position=true, connector = "str_pnt_006", arg = 313, arg_value = 0},
            {
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C
			    { CLSID	= "{8D399DDA-FF81-4F14-904D-099B34FE7918}", arg_value = 0.15 }, --AIM-7M
				{CLSID  = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.15 }, -- MK-82
				{CLSID  = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", arg_value = 0.15 }, -- MK-20 Rockeye (Beluga stand-in must change)
				{CLSID  = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", arg_value = 0.15 }, -- GBU-12
            }
        ),
		pylon(9, 0, 1.048000, -0.543000, 0.802000,
            {
  				use_full_connector_position = true,
			},
            {
                --
            }
        ),
        pylon(10, 0, -1.809, -0.556, -2.333, {use_full_connector_position=true, connector = "str_pnt_008", arg = 315, arg_value = 0},
            {
                { CLSID = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}", arg_value = 0.15 },--SUPER 530F
                { CLSID = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", arg_value = 0.15 },--MICA RF
                { CLSID = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", arg_value = 0.15 },--MICA IR
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C
			    { CLSID	= "{8D399DDA-FF81-4F14-904D-099B34FE7918}", arg_value = 0.15 }, --AIM-7M
				{CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", arg_value = 0.35 }, -- MK-20 Rockeye (Beluga stand-in must change)
				{CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.35 }, -- MK-82
				{CLSID = "{M2KC_02_RPL541}", arg_value = 0.0 }, -- RPL 541 Fuel Tank
            }
        ),
        pylon(11, 0,  -3.086, -0.587, -3.311, {use_full_connector_position=true, connector = "str_pnt_009", arg = 316, arg_value = 0},
            {
                { CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 },
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - red
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - green
		        { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - blue
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - white
			    { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}", arg_value = 0.15,arg_increment = -0.1 }, --Smokewinder - yellow
			    { CLSID	= "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", arg_value = 0.15 }, --AIM-9M
			    { CLSID	= "{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", arg_value = 0.15 }, --AIM-9P
			    { CLSID	= "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.15 }, --AIM-120B				
			    { CLSID	= "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.15 }, --AIM-120C	
				{CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", arg_value = 0.15 }, -- Magic R.550	
            }
        ),
},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
--  	aircraft_task(GroundAttack),
--     	aircraft_task(CAS),
--      aircraft_task(AFAC),
--	    aircraft_task(RunwayAttack),
--  	aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(FighterSweep),

	SFM_Data = {
	aerodynamics = --F15
		{
			Cy0	=	0,
			Mzalfa	=	6,
			Mzalfadt	=	1,
			kjx = 2.95,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.0268,
			cx_flap = 0.06,
			cy_flap = 0.4,
			cx_brk = 0.06,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0.0,	0.0215,		0.055,		0.08,		0.22,	0.65,	25.0,	1.2 	},
				{0.2,	0.0215,		0.055,		0.08,		0.22,	1.80,	25.0,	1.2     },
				{0.4,	0.0215,		0.055,		0.08,	   	0.22,	3.00,	25.0,	1.2     },
				{0.6,	0.0215,		0.055,		0.05,		0.28,	4.20,	25.0,	1.2     },
				{0.7,	0.0215,		0.055,		0.05,		0.28,	4.20,	23.0,	1.15    },
				{0.8,	0.0215,		0.055,		0.05,		0.28,	4.20,	21.7,	1.1     },
				{0.9,	0.0230,		0.058,		0.09,		0.20,	4.20,	20.1,	1.07    },
				{1.0,	0.0320,		0.062,		0.17,		0.15,	4.20,	18.9,	1.04    },
				{1.1,	0.0430,		0.062,	   	0.235,		0.09,	3.78,	17.4,	1.02    },
				{1.2,	0.0460,		0.062,	   	0.285,		0.08,	2.94,	17.0,	1.00 	},		
				{1.3,	0.0470,		0.06,	   	0.29,		0.10,	2.10,	16.0,	0.92 	},				
				{1.4,	0.0470,		0.056,	   	0.3,		0.136,	1.80,	15.0,	0.80 	},					
				{1.6,	0.0470,		0.052,	   	0.34,		0.21,	1.08,	13.0,	0.7 	},					
				{1.8,	0.0460,		0.042,	   	0.34,		2.43,	0.96,	12.0,	0.55 	},		
				{2.2,	0.0420,		0.037,	   	0.49,		3.5,	0.84,	 10.0,	0.37 	},					
				{2.5,	0.0420,		0.033,		0.6,		4.7,	0.84,	 9.0,	0.3 	},		
				{3.9,	0.0400,		0.023,		0.9,		6.0,	0.84,	 7.0,	0.2		},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19.5,
			dcx_eng	=	0.0114,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	6000,
			dpdh_f	=	14000.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0.0,	115000,		212000},
				{0.2,	 94000,		200000},
				{0.4,	 92000,		205000},
				{0.6,	103000,		207000},
				{0.7,	105000,		210000},
				{0.8,	105000,		220000},
				{0.9,	105000,		235000},
				{1.0,	107000,		250000},
				{1.1,	103000,		258000},
				{1.2,	 94000,		268000},
				{1.3,	 84000,		285000},
				{1.4,	 71000,		300000},
				{1.6,	 34000,		318000},
				{1.8,	 19000,		337000},
				{2.2,	 17000,		370000},
				{2.5,	 19000,		390000},
				{3.9,	 82000,		310000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		-- NOSE, COCKPIT & AVIONICS
		[0]	 = {critical_damage =  3, args = {82}},		-- NOSE_CENTER
		[1]	 = {critical_damage =  5, args = {150}},	-- NOSE_LEFT_SIDE
		[2]	 = {critical_damage =  5, args = {149}},	-- NOSE_RIGHT_SIDE
		[3]	 = {critical_damage =  2, args = {65}},		-- COCKPIT
		[4]	 = {critical_damage =  5, args = {298}},	-- CABIN_LEFT_SIDE
		[5]	 = {critical_damage =  5, args = {299}},	-- CABIN_RIGHT_SIDE
		[90] = {critical_damage =  5},					-- PILOT
		[86] = {critical_damage =  4, args = {300}},	-- AVIONICS BAY 1 (PYLON1)
		[87] = {critical_damage =  4, args = {301}},	-- AVIONICS BAY 2 (PYLON2)
		[88] = {critical_damage =  4, args = {302}},	-- JAMMER (PYLON3)

		-- CONTROL SURFACES
		[53] = {critical_damage =  3, args = {248}},	-- RUDDER
		[25] = {critical_damage =  3, args = {226}},	-- AILERON L
		[51] = {critical_damage =  4, args = {240}},	-- ELEVATOR L IN
		[52] = {critical_damage =  4, args = {238}},	-- ELEVATOR R IN
		[26] = {critical_damage =  3, args = {216}},	-- AILERON R
		[21] = {critical_damage =  3, args = {232}},	-- SLAT L OUT
		[33] = {critical_damage =  4, args = {230}},	-- SLAT L IN
		[22] = {critical_damage =  3, args = {222}},	-- SLAT R OUT
		[34] = {critical_damage =  4, args = {220}},	-- SLAT R IN
		[19] = {critical_damage =  2, args = {183}},	-- AIRBRAKE LEFT
		[20] = {critical_damage =  2, args = {185}},	-- AIRBRAKE RIGHT

		-- ENGINE & FUEL TANKS
		[11] = {critical_damage = 8,  args = {271}},	-- ENGINE
		[61] = {critical_damage = 7,  args = {224}},	-- FUEL_TANK_LEFT_SIDE
		[62] = {critical_damage = 7,  args = {214}},	-- FUEL_TANK_RIGHT_SIDE
		[65] = {critical_damage = 7,  args = {155}},	-- FUEL_TANK_CENTER (BLADE_1_CENTER)
		[66] = {critical_damage = 3               },	-- BATTERY (BLADE_1_OUT)
		[67] = {critical_damage = 3               },	-- ALTERNATOR 1 (BLADE_2_IN)
		[68] = {critical_damage = 3               },	-- ALTERNATOR 2 (BLADE_2_CENTER)
		[69] = {critical_damage = 3               },	-- CONVERTER 1 (BLADE_2_OUT)
		[70] = {critical_damage = 3               },	-- CONVERTER 2 (BLADE_3_IN)
		[71] = {critical_damage = 3               },	-- HYD PUMP 1 (BLADE_3_CENTER)
		[72] = {critical_damage = 3               },	-- HYD PUMP 2 (BLADE_3_OUT)

		-- FUSELAGE & WINGS
		[39] = {critical_damage = 3,  args = {244}},								-- FIN L TOP
		[41] = {critical_damage = 4,  args = {245}, deps_cells = {39,53}},			-- FIN L CENTER
		[43] = {critical_damage = 5,  args = {246}, deps_cells = {41,88}},			-- FIN L BOTTOM
		[23] = {critical_damage = 3,  args = {223}, deps_cells = {21}},				-- WING_L_OUT
		[29] = {critical_damage = 5,  args = {224}, deps_cells = {19,23,84}},	    -- WING_L_CENTER
		[35] = {critical_damage = 7,  args = {225}, deps_cells = {23,21,29,33,61,15,84}},	-- WING_L_IN
		[36] = {critical_damage = 7,  args = {215}, deps_cells = {24,22,30,34,62,16,85}},	-- WING_R_IN
		[30] = {critical_damage = 5,  args = {214}, deps_cells = {20,24,85}},	    -- WING_R_CENTER
		[24] = {critical_damage = 3,  args = {213}, deps_cells = {22}},				-- WING_R_OUT
		[9]	 = {critical_damage = 5,  args = {154}},								-- FUSELAGE_LEFT_SIDE
		[82] = {critical_damage = 5,  args = {152}, deps_cells = {11}},				-- FUSELAGE_BOTTOM
		[10] = {critical_damage = 5,  args = {153}},								-- FUSELAGE_RIGHT_SIDE
		[55] = {critical_damage = 4,  args = {159}, deps_cells = {11}},				-- TAIL PIPE
		[56] = {critical_damage = 4,  args = {158}},								-- TAIL LEFT
		[57] = {critical_damage = 4,  args = {157}},								-- TAIL RIGHT
		[58] = {critical_damage = 4,  args = {156}, deps_cells = {11}}, 			-- TAIL BOTTOM

		-- LANDING GEAR
		[8]  = {critical_damage = 6, args = {265}, deps_cells = {83}},	-- FRONT_GEAR_BOX
		[15] = {critical_damage = 6, args = {267}, deps_cells = {84}},	-- LEFT_GEAR_BOX
		[16] = {critical_damage = 6, args = {266}, deps_cells = {85}},	-- RIGHT_GEAR_BOX
		[83] = {critical_damage = 3, args = {134}},						-- WHEEL F
		[84] = {critical_damage = 3, args = {135}},						-- WHEEL L
		[85] = {critical_damage = 3, args = {136}},						-- WHEEL R

		-- WEAPONS
		[7]  = {critical_damage = 3, args = {296}},						-- GUNS

	},
	
	DamageParts = 
	{  
		[1] = "M-2000c-oblomok-wing-R", -- wing R
		[2] = "M-2000c-oblomok-wing-L", -- wing L
		[1000 + 0]  = "M2KC-fragment-nose",
		[1000 + 1]  = "M2KC-fragment-nose-1",
		[1000 + 35] = "M-2000c-oblomok-wing-L",
		[1000 + 29] = "M-2000c-oblomok-wing-L",
		[1000 + 23] = "M-2000c-oblomok-wing-L",
		[1000 + 35] = "M-2000c-oblomok-wing-R",
		[1000 + 29] = "M-2000c-oblomok-wing-R",
		[1000 + 23] = "M-2000c-oblomok-wing-R",
		[1000 + 47] = "M2KC-fragment-stabilizador-L",
		[1000 + 48] = "M2KC-fragment-stabilizador-R",
		[1000 + 55] = "M2KC-fragment-tail",
		[1000 + 41] = "M2KC-fragment-fin-center",
		[1000 + 5]  = "M2KC-fragment-canopy",
		[1000 + 3]  = "M2KC-fragment-canopy-back",
	},
	

	lights_data =
	{
		typename =	"collection",
		lights 	 = 
		{
			[WOLALIGHT_STROBES]	= {
				typename	=	"collection",
				lights 		= {
					{typename = "argnatostrobelight",  argument = 83,  period = 1.333,  phase_shift = 0.0}, -- Top Strobe
					{typename = "argnatostrobelight",  argument = 802, period = 1.333,  phase_shift = 0.5}, -- Bottom Strobe
				},
			},--must be collection
			[WOLALIGHT_LANDING_LIGHTS]	= {
				typename	= 	"collection",
				lights		= {
					{typename = "argumentlight", argument = 208, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
					{typename = "argumentlight", argument = 208, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
				},
			},--must be collection
			[WOLALIGHT_TAXI_LIGHTS]	= {
				typename	= 	"collection",
				lights		= {
					{typename = "argumentlight", argument = 209, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
					{typename = "argumentlight", argument = 209, dir_correction = {elevation = math.rad(3)}, speed = 1.0},
				},
			},--must be collection
			[WOLALIGHT_NAVLIGHTS]	= {
				typename 	= "collection",
				lights 		= {
					{typename = "argumentlight",  argument  = 190}, --Red Position
					{typename = "argumentlight",  argument  = 192}, --Green Position
					{typename = "argumentlight",  argument  = 191}, --White Position
				},
			},--must be collection
			[WOLALIGHT_FORMATION_LIGHTS] = {
				typename	= "collection",
				lights		= {
					{typename = "argumentlight",argument = 200}, -- form front
					{typename = "argumentlight",argument = 201}, -- form aft
				},		-- green bars
			},--must be collection
			-- REFUEL
			[WOLALIGHT_REFUEL_LIGHTS] = {
				typename = "collection",
				lights	 = {
					{typename = "argumentlight", connector = "CNT_RF1", color = {0.99, 0.99, 0.99}, pos_correction  = {0, 0, 0.0}, argument  = 903}, -- Right Side Low
					{typename = "argumentlight", connector = "CNT_RF2", color = {0.99, 0.99, 0.99}, pos_correction  = {0, 0, 0.0}, argument  = 907, speed = 1.0}, -- Right Side High
					{typename = "argumentlight", connector = "CNT_RF3", color = {0.99, 0.99, 0.99}, pos_correction  = {0, 0, 0.0}, argument  = 908, speed = 1.0}, -- Nose High
				},
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				typename = "collection",
				lights = {
					{ typename = "argumentlight", argument = 69, },
				},
			},
		}, -- end of lights
	},-- end of lights_data
}

add_aircraft(VSN_M2000) --AG
