
-- Dynamic Traffic Spwan Script (DTSS) [v0.4]
-- A script that make the Caucasus alive.

-- by Hencor
-- using Grimes and Speeds Mission Scripting Tools MiST

-- Dynamically spawns groups of aircrafts around nearest airbases, farps and aircraftcarriers 
-- Groups are deleted when out of sight/range
-- By now in 3 different altitudes (low, medium and contrail) 
-- Altitude, spawnradius, flightsize, numbers of groups, delete-distance, aktivation-distance and types of aircrafts are fully configurable

-- READ FIRST:
-- Loading MIST befor this script is required!!
-- Groups only spawn at airfields that belong with your coalition! NEUTRAL airfields don't work!!!

do

DTS_FixedWing_Medium = {'A-50', 'An-26B','An-30M','IL-78M','IL-76MD','C-130','A-10C','C-101CC'} --types of aircrafts for medium altitude
DTS_FixedWing_Low = {'L-39ZA', 'MiG-21Bis','SU-24MR','Su-25','C-101CC','A-10','A-10C','B-1B','M-2000C'}--types of aircrafts for low altitude
DTS_FixedWing_Contrail = {'MiG-21Bis','SU-24MR','IL-78M','IL-76MD','A-50','B-52H','C-17A','E-3A','F-117A','F-15C','F-15E','F-16A','F-16C bl.52d','F/A-18C','MiG-29A','MiG-31','MiG-25RBT','Su-33','M-2000C'}--types of aircrafts for contrail altitude

-- numbers of maximum active groups
DTS_TraficIntensity = { 
["medium"] = 1, 	--numbers of groups spawn at medium altitude
["low"] = 1,		--numbers of groups spawn at low altitude
["contrail"] = 4}	--numbers of groups spawn at contrail altitude

DTSConf_Aktivation_Distance = 9000 --meter / adjust the distance between player and airdrome to aktivate trafic
DTSConf_Spawn_Radius = 12000 --meter / variation of spwan points around the nearest airdrome
DTSConf_DeleteDist = 30000--meter / adjust the distance between player und trafic groups to delete groups


DTSConf_AngleLow_FlightSize = math.random(1,4)  -- flightsize AngleLow-Groups, a number between default (1,4)
DTSConf_AngleLow_Altitude = {1000,3000}			-- meter / altitude AngleLow-Groups, a number between default (1000,3000)
DTSConf_AngleLow_Speed ={300,400}				-- knots / speed AngleLow-Groups, a number between default (300,400)*

DTSConf_AngleMedium_FlightSize = math.random(1,1) -- flightsize AngleMedium-Groups, a number between default (1,4)
DTSConf_AngleMedium_Altitude = {3500,5000}		  -- meter / altitude AngleMedium-Groups, a number between default (1000,3000)
DTSConf_AngleMedium_Speed ={300,400}			  -- knots / speed AngleMedium-Groups, a number between default (300,400)*

DTSConf_AngleContrail_FlightSize = math.random(1,2) -- flightsize AngleContrail-Groups, a number between default (1,4)
DTSConf_AngleContrail_Altitude = {9100,10000} 		-- meter ~30000,33000 feet / altitude AngleContrail-Groups, a number between default (1000,3000)
DTSConf_AngleContrail_Speed ={280,300}				-- knots / speed AngleContrail-Groups, a number between default (300,400)*
DTSConf_AngleContrail_AltitudeType = 'BARO'

DTSConf_AltitudeType = 'RADIO'

_debug = false

--*By now there are speeds configured for nearly each aircrafttype self. This value is just a standard if there are no aircraft specific values. MAYBE SUBJECT TO CHANGE

-- Aircraft Definition
RTFighters = {
	[1] = {
		["type"] = "F-15C",
		["active"] = true,
		["payload"] = {
			["pylons"] =
			{
				[1] =
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] =
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] =
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] =
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [4]
				[5] =
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [5]
				[6] =
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [6]
				[7] =
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [7]
				[8] =
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [8]
				[9] =
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [9]
				[10] =
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[11] =
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [11]
			}, -- end of ["pylons"]
			["fuel"] = "6103",
			["flare"] = 60,
			["chaff"] = 120,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.ISRAEL
		},
		["liveries"] = { 
			[1] = { "12th Fighter SQN (AK)", "390th Fighter SQN", "493rd Fighter SQN (LN)", "58th Fighter SQN (EG)",
				"65th Aggressor SQN (WA) Flanker", "65th Aggressor SQN (WA) MiG", "65th Aggressor SQN (WA) SUPER_Flanker", "Ferris Scheme"
			}, -- liveries for ["countries"][1]
			[2] = { "106th SQN (8th Airbase)" } -- liveries for ["countries"][2]
		}
	}, -- end of [1]
	[2] = {
		["type"] = "Su-27",
		["active"] = true,
		["payload"] = {
			["pylons"] = {
				[1] =
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] =
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] =
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] =
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] =
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] =
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] =
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] =
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [8]
				[9] =
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] =
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
			}, -- end of ["pylons"]
			["fuel"] = "9400",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.CHINA,
			[3] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "Air Force Standard", "Air Force Standard Early", "Air Force Standard old", "Besovets AFB", "Besovets AFB 2 squadron",
				"Chkalovsk AFB (689 GvIAP)", "Hotilovo AFB", "Kazakhstan Air Defense Forces", "Klipyavr AFB (Maresyev)",
				"Kubinka AFB (Russian Knights Old)", "Kubinka AFB (Russion Knights)", "Lodeynoye pole AFB (177 IAP)",
				"Lypetsk AFB (Falcons of Russia)", "Lypetsk AFB (Shark)", "M Gromov FRI"
			}, -- liveries for ["countries"][1]
			[2] = { "PLAAF K1S old", "PLAAF K2S new", "PLAAF K2S old", "PLAAF K33S", "PLAAF Standard", "PLANAF HH8S" }, -- liveries for ["countries"][2]
			[3] = { "Air Force Ukraine Standard", "Air Force Ukraine Early", "Mirgorod AFB (831th brigade)", 
				"Mirgorod AFB (Digital camo)", "Ozerne AFB (9th brigade)"
			} -- liveries for ["countries"][3]
		}
	}, -- end of [2]
	[3] = {
		["type"] = "Tornado GR4",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
				}, -- end of [4]
				[11] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [11]
				[10] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [10]
				[12] = 
				{
					["CLSID"] = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}",
				}, -- end of [12]
				[9] = 
				{
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
				}, -- end of [9]
			}, -- end of ["pylons"]
			["fuel"] = "4663",
			["flare"] = 45,
			["chaff"] = 90,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.UK,
		},
		["liveries"] = { 
			[1] = { "bb of 14 squadron raf lossiemouth", "no. 9 squadron raf marham ab (norfolk)",
				"no. 12 squadron raf lossiemouth ab (morayshire)", "no. 14 squadron raf lossiemouth ab (morayshire)",
				"no. 617 squadron raf lossiemouth ab (morayshire)", "o of ii (ac) squadron raf marham"
			}, -- liveries for ["countries"][1]
		}
	}, -- end of [3]
	[4] = {
		["type"] = "F-4E",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
				}, -- end of [9]
			}, -- end of ["pylons"]
			["fuel"] = "4864",
			["flare"] = 30,
			["chaff"] = 60,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.GERMANY,
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
		}
	}, -- end of [4]
	[5] = {
		["type"] = "Tornado IDS",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[5] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [8]
				[10] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{EF124821-F9BB-4314-A153-E0E2FE1162C4}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}",
				}, -- end of [12]
			}, -- end of ["pylons"]
			["fuel"] = "4663",
			["flare"] = 45,
			["chaff"] = 90,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.GERMANY,
			[2] = country.id.ITALY
		},
		["liveries"] = { 
			[1] = { "aufklarungsgeschwader 51 `immelmann` jagel ab luftwaffe", "jagdbombergeschwader 31 `boelcke` norvenich ab luftwaffe",
				"jagdbombergeschwader 32 lechfeld ab luftwaffe", "jagdbombergeschwader 33 buchel ab no. 43+19 experimental scheme",
				"marinefliegergeschwader 2 eggebek ab marineflieger"
			}, -- liveries for ["countries"][1]
			[2] = { "ITA Tornado (Sesto Stormo Diavoli Rossi)", "ITA Tornado Black",
				"ITA Tornado MM7042", "ITA Tornado MM55004"
			} -- liveries for ["countries"][2]
		}
	}, -- end of [5]
	[6] = {
		["type"] = "F-16A MLU",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [10]
			}, -- end of ["pylons"]
			["fuel"] = "3104",
			["flare"] = 30,
			["chaff"] = 60,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.BELGIUM,
			[2] = country.id.NORWAY,
			[3] = country.id.DENMARK,
			[4] = country.id.THE_NETHERLANDS
		},
		["liveries"] = { 
			[1] = { "2nd squadron `comet` florennes ab"	}, -- liveries for ["countries"][1]
			[2] = { "norway 338 skvadron", "norway skv338" }, -- liveries for ["countries"][2]
			[3] = { "rdaf f16 standard-1" }, -- liveries for ["countries"][3]
			[4] = { "the netherlands (313th squadron `` twenthe ab)", "the netherlands 313th `tigers` squadron" } -- liveries for ["countries"][4]
		}
	}, -- end of [6]
	[7] = {
		["type"] = "A-10C",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "ALQ_184",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{319293F2-392C-4617-8315-7C88C22AF7C4}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{GBU-38}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{GBU-38}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
				}, -- end of [11]
			}, -- end of ["pylons"]
			["fuel"] = 5029,
			["flare"] = 120,
			["ammo_type"] = 1,
			["chaff"] = 240,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.AUSTRALIA,
			[3] = country.id.CANADA,
			[4] = country.id.TURKEY,
			[5] = country.id.UK,
			[6] = country.id.THE_NETHERLANDS,
			[7] = country.id.BELGIUM,
			[8] = country.id.DENMARK
		},
		["liveries"] = { 
			[1] = { "23rd TFW England AFB (EL)", "25th FS Osan AB, Korea (OS)", "47th FS Barksdale AFB, Louisiana (BD)",
				"66th WS Nellis AFB, Nevada (WA)", "74th FS Moody AFB, Georgia (FT)", "81st FS Spangdahlem AB, Germany (SP) 1",
				"81st FS Spangdahlem AB, Germany (SP) 2", "104th FS Maryland ANG, Baltimore (MD)", "118th FS Bradley ANGB, Connecticut (CT)",
				"118th FS Bradley ANGB, Connecticut (CT) N621", "172nd FS Battle Creek ANGB, Michigan (BC)", 
				"184th FS Arkansas ANG, Fort Smith (FS)", "190th FS Boise ANGB, Idaho (ID)", "354th FS Davis Monthan AFB, Arizona (DM)",
				"355th FS Eielson AFB, Alaska (AK)", "357th FS Davis Monthan AFB, Arizona (DM)", "358th FS Davis Monthan AFB, Arizona (DM)",
				"422nd TES Nellis AFB, Nevada (OT)"
			}, -- liveries for ["countries"][1]
			[2] = { "Australia Notional RAAF" }, -- liveries for ["countries"][2]
			[3] = { "Canada RCAF 409 Squadron", "Canada RCAF 442 Snow Scheme" }, -- liveries for ["countries"][3]
			[4] = { "A-10 Grey" }, -- liveries for ["countries"][4]
			[5] = { "A-10 Grey" }, -- liveries for ["countries"][5]
			[6] = { "A-10 Grey" }, -- liveries for ["countries"][6]
			[7] = { "A-10 Grey" }, -- liveries for ["countries"][7]
			[8] = { "A-10 Grey" }, -- liveries for ["countries"][8]
		}
	}, -- end of [7]
	[8] = {
		["type"] = "F-14A",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{7575BA0B-7294-4844-857B-031A144B2595}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{7575BA0B-7294-4844-857B-031A144B2595}",
				}, -- end of [5]
				[8] = 
				{
					["CLSID"] = "{7575BA0B-7294-4844-857B-031A144B2595}",
				}, -- end of [8]
				[11] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [11]
				[9] = 
				{
					["CLSID"] = "{7575BA0B-7294-4844-857B-031A144B2595}",
				}, -- end of [9]
				[12] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [12]
			}, -- end of ["pylons"]
			["fuel"] = "7348",
			["flare"] = 15,
			["chaff"] = 30,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
		},
		["liveries"] = { 
			[1] = { "vf-1 `wolfpack`", "vf-33 `starfighters`", "vf-41 `black aces`", "vf-84 `jolly rogers`",
				"vf-111 `sundowners`- 1", "vf-111 `sundowners`- 2", "vf-142 `ghost riders`", "vf-143 `pukin's dogs`",
				"vf-xxx `aardvarks`"
			}, -- liveries for ["countries"][1]
		}
	}, -- end of [8]
	[9] = {
		["type"] = "F-15E",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [12]
				[13] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [13]
				[14] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [14]
				[15] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [15]
				[16] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [16]
				[17] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [17]
				[18] = 
				{
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
				}, -- end of [18]
				[19] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [19]
			}, -- end of ["pylons"]
			["fuel"] = "10246",
			["flare"] = 60,
			["chaff"] = 120,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.ISRAEL
		},
		["liveries"] = { 
			[1] = { "335th Fighter SQN (SJ)", "492d Fighter SQN (LN)" }, -- liveries for ["countries"][1]
			[2] = { "IDF No 69 Hammers Squadron" }, -- liveries for ["countries"][2]
		}
	}, -- end of [9]
	[10] = {
		["type"] = "F-16A",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [10]
			}, -- end of ["pylons"]
			["fuel"] = "3104",
			["flare"] = 30,
			["chaff"] = 60,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.DENMARK
		},
		["liveries"] = { 
			[1] = { "usaf f16 standard-1" }, -- liveries for ["countries"][1]
			[2] = { "standard_denmark" }, -- liveries for ["countries"][2]
		}
	}, -- end of [10]
	[11] = {
		["type"] = "F-16C bl.52d",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [4]
				[6] = 
				{
					["CLSID"] = "ALQ_184",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
				}, -- end of [10]
			}, -- end of ["pylons"]
			["fuel"] = "3104",
			["flare"] = 45,
			["chaff"] = 90,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.ISRAEL
		},
		["liveries"] = { 
			[1] = { "pacaf 14th fs (mj) misawa afb", "pacaf 35th fw (ww) misawa afb", "usaf 77th fs (sw) shaw afb",
				"usaf 147th fig (ef) ellington afb", "usaf 412th tw (ed) edwards afb", "usaf 414th cts (wa) nellis afb",
				"usafe 22nd fs (sp) spangdahlem afb", "usafe 555th fs (av) aviano afb"
			}, -- liveries for ["countries"][1]
			[2] = { "idf_af f16c standard" }, -- liveries for ["countries"][2]
		}
	}, -- end of [11]
	[12] = {
		["type"] = "F-86F Sabre",
		["active"] = false,
		["payload"] = 
		{
			["pylons"] = 
			{
				[5] = 
				{
					["CLSID"] = "{GAR-8}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{GAR-8}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				}, -- end of [7]
				[4] = 
				{
					["CLSID"] = "{PTB_120_F86F35}",
				}, -- end of [4]
			}, -- end of ["pylons"]
			["fuel"] = 1282,
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
		},
		["liveries"] = { 
			[1] = { "US Air Force", "US Air Force (code FU-178)", "US Air Force (ex-USAF F-86A Sabre)" }, -- liveries for ["countries"][1]
		}
	}, -- end of [12]
	[13] = {
		["type"] = "F/A-18C",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{EFEC8201-B922-11d7-9897-000476191836}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{EFEC8201-B922-11d7-9897-000476191836}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{EFEC8201-B922-11d7-9897-000476191836}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [9]
			}, -- end of ["pylons"]
			["fuel"] = "6531",
			["flare"] = 15,
			["chaff"] = 30,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.AUSTRALIA
		},
		["liveries"] = { 
			[1] = { "NSAWC_25", "NSAWC_44", "VFA-94", "VFC-12" }, -- liveries for ["countries"][1]
			[2] = { "Australia 75 Sqn RAAF" }, -- liveries for ["countries"][2]
		}
	}, -- end of [13]
	[14] = {
		["type"] = "Hawk",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[2] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
				}, -- end of [4]
			}, -- end of ["pylons"]
			["fuel"] = 1272,
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.UK,
			[3] = country.id.SWITZERLAND,
			[4] = country.id.FINLAND
		},
		["liveries"] = { 
			[1] = { "12th FTW, Randolph AFB, Texas (RA)", "1st RS, Beale AFB, California (BB)",
				"25th FTS, Vance AFB, Oklahoma (VN)", "509th BS, Whitman AFB, Missouri (WM)",
				"88th FTS, Sheppard AFB, Texas (EN)", "NAS Meridian Mississippi Seven (VT-7)"
			}, -- liveries for ["countries"][1]
			[2] = { "XX226 - 74Sqn 1992-2000", "XX316 - 74Sqn 1998-2000", "XX218 - 208Sqn",
				"XX175 - FRADU Royal Navy", "XX316 - FRADU Royal Navy"
			}, -- liveries for ["countries"][2]
			[3] = { "Swiss U-1251 - White", "Swiss U-1252 - Normal", "Swiss U-1268 - ByeByeHawk",
				"Swiss U-1270 - Wallis"
			}, -- liveries for ["countries"][3]
			[4] = { "Finland HW-341 Grey", "Finland HW-373 Ex-Swiss Air Force" }, -- liveries for ["countries"][4]
		}
	}, -- end of [14]
	[15] = {
		["type"] = "L-39C",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [1]
				[3] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [3]
			}, -- end of ["pylons"]
			["fuel"] = 823.2,
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.GERMANY,
			[3] = country.id.UKRAINE,
			[4] = country.id.CHEZH_REPUBLIC
		},
		["liveries"] = { 
			[1] = { "Russ Jet Team", "Russian Air Force", "Russian Air Force Navy", "Russian Air Force Old" }, -- liveries for ["countries"][1]
			[2] = { "DDR Luftwaffe", "DDR Luftwaffe Early" }, -- liveries for ["countries"][2]
			[3] = { "Ukraine Air Force UKHW" }, -- liveries for ["countries"][3]
			[4] = { "Czech Air Force", "Czech Air Force CLV", "Czechoslovakia Air Force" }, -- liveries for ["countries"][4]
		}
	}, -- end of [15]
	[16] = {
		["type"] = "M-2000C",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
				}, -- end of [2]
				[5] = 
				{
					["CLSID"] = "{M2KC_RPL_522}",
				}, -- end of [5]
				[9] = 
				{
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
				}, -- end of [9]
				[8] = 
				{
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
				}, -- end of [8]
			}, -- end of ["pylons"]
			["fuel"] = 3165,
			["flare"] = 16,
			["chaff"] = 112,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.FRANCE,
			[2] = country.id.GREECE,
			[3] = country.id.SAUDI_ARABIA			
		},
		["liveries"] = { 
			[1] = { "AdA Chasse 2/5" }, -- liveries for ["countries"][1]
			[2] = { "Polemikh Aeroporia (Greek Air Force)" }, -- liveries for ["countries"][2]
			[3] = { "UAE Air Defense Air Force" }, -- liveries for ["countries"][3]
		}
	}, -- end of [16]
	[17] = {
		["type"] = "MiG-15bis",
		["active"] = false,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "PTB400_MIG15",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "PTB400_MIG15",
				}, -- end of [2]
			}, -- end of ["pylons"]
			["fuel"] = 1172,
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.NORTH_KOREA,
			[3] = country.id.CHINA,
			[4] = country.id.CHEZH_REPUBLIC,
			[5] = country.id.GERMANY,
			[6] = country.id.POLAND
		},
		["liveries"] = { 
			[1] = { "USSR_Air Forces", "USSR_Pepalyaev", "USSR_Red" }, -- liveries for ["countries"][1]
			[2] = { "North_Korea_Air Force", "North_Korea_Air Force_Major_Arkady_Boitsow" }, -- liveries for ["countries"][2]
			[3] = { "China Volunteer Air Force", "China_Air Force" }, -- liveries for ["countries"][3]
			[4] = { "Czechoslovakia_Air Force" }, -- liveries for ["countries"][4]
			[5] = { "GDR_Air Force" }, -- liveries for ["countries"][5]
			[6] = { "Polish_Air Force" }, -- liveries for ["countries"][6]
		}
	}, -- end of [17]
	[18] = {
		["type"] = "MiG-21Bis",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{R-60M 2L}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-3R}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{PTB_800_MIG21}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{R-3R}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-60M 2R}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{ASO-2}",
				}, -- end of [6]
			}, -- end of ["pylons"]
			["fuel"] = 2280,
			["flare"] = 32,
			["ammo_type"] = 1,
			["chaff"] = 32,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.SERBIA,
			[3] = country.id.BULGARIA,
			[4] = country.id.CROATIA,
			[5] = country.id.EGYPT,
			[6] = country.id.FINLAND,
			[7] = country.id.GERMANY,
			[8] = country.id.INDIA,
			[9] = country.id.POLAND
		},
		["liveries"] = { 
			[1] = { "VVS Camo", "VVS Grey" }, -- liveries for ["countries"][1]
			[2] = { "Serbia - 101 FS" }, -- liveries for ["countries"][2]
			[3] = { "Bulgaria" }, -- liveries for ["countries"][3]
			[4] = { "Croatia - 1992" }, -- liveries for ["countries"][4]
			[5] = { "Egypt Grey", "Egypt Tan" }, -- liveries for ["countries"][5]
			[6] = { "Finland - HavLLv 31" }, -- liveries for ["countries"][6]
			[7] = { "Germany East" }, -- liveries for ["countries"][7]
			[8] = { "India - 15 Sqn" }, -- liveries for ["countries"][8]
			[9] = { "Poland - 1 DLMW", "Poland - Metal" }, -- liveries for ["countries"][9]
		}
	}, -- end of [18]
	[19] = {
		["type"] = "S-3B",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{8B7CADF9-4954-46B3-8CFB-93F2F5B90B03}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
				}, -- end of [2]
				[5] = 
				{
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{8B7CADF9-4954-46B3-8CFB-93F2F5B90B03}",
				}, -- end of [6]
			}, -- end of ["pylons"]
			["fuel"] = "5500",
			["flare"] = 30,
			["chaff"] = 30,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
		},
		["liveries"] = { 
			[1] = { "usaf standard" }, -- liveries for ["countries"][1]
		}
	}, -- end of [19]
	[20] = {
		["type"] = "Mirage 2000-5",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
				}, -- end of [9]
			}, -- end of ["pylons"]
			["fuel"] = "3160",
			["flare"] = 16,
			["chaff"] = 112,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.FRANCE,
		},
		["liveries"] = { 
			[1] = { "ec1_2  spa12 `cigogne a ailes ouvertes`", "ec1_2  spa103 `cigogne de fonck`",
				"ec1_2 spa3 `cigogne de guynemer`", "ec2_2 `cote d'or` spa57 `mouette`",
				"ec2_2 `cote d'or` spa65 `chimere`", "ec2_2 spa94 `lamort qui fauche`"
			}, -- liveries for ["countries"][1]
		}
	}, -- end of [20]
	[21] = {
		["type"] = "L-39ZA",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [2]
				[4] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{R-3S}",
				}, -- end of [5]
			}, -- end of ["pylons"]
			["fuel"] = 823.2,
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.ABKHAZIA,
			[3] = country.id.CHEZH_REPUBLIC,
			[4] = country.id.GEORGIA,
			[5] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "Russian Air Force 1", "Russian Air Force Old" }, -- liveries for ["countries"][1]
			[2] = { "Abkhazian Air Force" }, -- liveries for ["countries"][2]
			[3] = { "Czech Air Force" }, -- liveries for ["countries"][3]
			[4] = { "Georgian Air Force" }, -- liveries for ["countries"][4]
			[5] = { "Ukraine Air Force 1" }, -- liveries for ["countries"][5]
		}
	}, -- end of [21]
	[22] = {
		["type"] = "MiG-23MLD",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[2] = 
				{
					["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
				}, -- end of [6]
			}, -- end of ["pylons"]
			["fuel"] = "3800",
			["flare"] = 60,
			["chaff"] = 60,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard", "af standard-1", "af standard-2", "af standard-3 (worn-out)" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}
	}, -- end of [22]
	[23] = {
		["type"] = "MiG-25PD",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [4]
			}, -- end of ["pylons"]
			["fuel"] = "15245",
			["flare"] = 64,
			["chaff"] = 64,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}
	}, -- end of [23]
	[24] = {
		["type"] = "MiG-25RBT",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[4] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [4]
			}, -- end of ["pylons"]
			["fuel"] = "15245",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}
	}, -- end of [24]
	[25] = {
		["type"] = "MiG-27K",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[2] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [8]
			}, -- end of ["pylons"]
			["fuel"] = "4500",
			["flare"] = 60,
			["chaff"] = 60,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}
	}, -- end of [25]
	[26] = {
		["type"] = "MiG-29A",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [7]
			}, -- end of ["pylons"]
			["fuel"] = "3380",
			["flare"] = 30,
			["chaff"] = 30,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE,
			[3] = country.id.GERMANY
		},
		["liveries"] = { 
			[1] = { "`swifts` team #44 kubinka ab", "120 gviap #45 domna ab" }, -- liveries for ["countries"][1]
			[2] = { "40th fw `maestro` vasilkov ab", "af standard-1", "af standard-2" }, -- liveries for ["countries"][2]
			[3] = { "33th iap wittstock ab (germany)", "968th iap altenburg ab (germany)", "luftwaffe 29+20 demo",
				"luftwaffe gray early", "luftwaffe gray-1", "luftwaffe gray-2(worn-out)", "luftwaffe gray-3", "luftwaffe gray-4"
			}, -- liveries for ["countries"][3]
		}
	}, -- end of [26]
	[27] = {
		["type"] = "MiG-29S",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [7]
			}, -- end of ["pylons"]
			["fuel"] = "3500",
			["flare"] = 30,
			["chaff"] = 30,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE,
		},
		["liveries"] = { 
			[1] = { "2nd fs `swifts` team, kubinka ab", "4th ctc lypetsk ab", "73th guards regiment, merzeburg ab (gdr)",
				"115th guards regiment, termez ab", "120th guards regiment, domna ab", "733th guards regiment, damgarten ab (gdr)",
				"1038th guards ctc, mary ab"
			}, -- liveries for ["countries"][1]
			[2] = { "`ukrainian falcons` paint scheme", "9th fw belbek ab", "14th army, vinnitsa ab" }, -- liveries for ["countries"][2]			
		}
	}, -- end of [27]
	[28] = {
		["type"] = "MiG-31",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
				}, -- end of [6]
			}, -- end of ["pylons"]
			["fuel"] = "15500",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
		},
		["liveries"] = { 
			[1] = { "174 GvIAP_Boris Safonov", "af standard" }, -- liveries for ["countries"][1]
		}
	}, -- end of [28]
	[29] = {
		["type"] = "Su-17M4",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [8]
			}, -- end of ["pylons"]
			["fuel"] = "3770",
			["flare"] = 64,
			["chaff"] = 64,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard (RUS)", "af standard (worn-out) (RUS)" }, -- liveries for ["countries"][1]
			[2] = { "af standard", "af standard (worn-out)", "shap lomanskoye ab" }, -- liveries for ["countries"][2]
		}
	}, -- end of [29]
	[30] = {
		["type"] = "Su-24M",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [3]
				[5] = 
				{
					["CLSID"] = "{16602053-4A12-40A2-B214-AB60D481B20E}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [8]
			}, -- end of ["pylons"]
			["fuel"] = "11700",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}
	}, -- end of [30]
	[31] = {
		["type"] = "Su-24MR",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{7D7EC917-05F6-49D4-8045-61FC587DD019}",
				}, -- end of [2]
				[5] = 
				{
					["CLSID"] = "{0519A262-0AB6-11d6-9193-00A0249B6F00}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{7D7EC917-05F6-49D4-8045-61FC587DD019}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{0519A261-0AB6-11d6-9193-00A0249B6F00}",
				}, -- end of [8]
			}, -- end of ["pylons"]
			["fuel"] = "11700",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}
	}, -- end of [31]
	[32] = {
		["type"] = "Su-25",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [10]
			}, -- end of ["pylons"]
			["fuel"] = "2835",
			["flare"] = 128,
			["chaff"] = 128,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE,
			[3] = country.id.ABKHAZIA,
			[4] = country.id.GEORGIA
		},
		["liveries"] = { 
			[1] = { "field camo scheme #1 (native)", "field camo scheme #2 (native). 960th shap",
				"field camo scheme #3 (worn-out). 960th shap", "forest camo scheme #1 (native)"
			}, -- liveries for ["countries"][1]
			[2] = { "broken camo scheme #1 (native). 299th oshap", "broken camo scheme #2 (native). 452th shap",
				"petal camo scheme #1 (native). 299th brigade", "petal camo scheme #2 (native). 299th brigade"
			}, -- liveries for ["countries"][2]
			[3] = { "Abkhazian Air Force" }, -- liveries for ["countries"][3]
			[4] = { "field camo scheme #1 (native)01" } -- liveries for ["countries"][4]
		}
	}, -- end of [32]
	[33] = {
		["type"] = "Su-25T",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82D}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E92CBFE5-C153-11d8-9897-000476191836}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E92CBFE5-C153-11d8-9897-000476191836}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82C}",
				}, -- end of [11]
			}, -- end of ["pylons"]
			["fuel"] = "3790",
			["flare"] = 128,
			["chaff"] = 128,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.GEORGIA
		},
		["liveries"] = { 
			[1] = { "af standard 1", "af standard 2" }, -- liveries for ["countries"][1]
			[2] = { "af standard", "af standard 101" }, -- liveries for ["countries"][2]
		}
	}, -- end of [33]
	[34] = {
		["type"] = "Su-25TM",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [5]
				[7] = 
				{
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
				}, -- end of [11]
			}, -- end of ["pylons"]
			["fuel"] = "3790",
			["flare"] = 128,
			["chaff"] = 128,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
		},
		["liveries"] = { 
			[1] = { "Flight Research Institute  VVS" }, -- liveries for ["countries"][1]
		}
	}, -- end of [34]
	[35] = {
		["type"] = "Su-30",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [10]
			}, -- end of ["pylons"]
			["fuel"] = "9400",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
		},
		["liveries"] = { 
			[1] = { "`russian knights` team #25", "`test-pilots` team #597", "adf 148th ctc savasleyka ab",
				"af standard", "af standard early", "af standard early (worn-out)", "af standard last", "af standard last (worn-out)"
			}, -- liveries for ["countries"][1]
		}
	}, -- end of [35]
	[36] = {
		["type"] = "Su-33",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [12]
			}, -- end of ["pylons"]
			["fuel"] = "9400",
			["flare"] = 48,
			["chaff"] = 48,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
		},
		["liveries"] = { 
			[1] = { "279th kiap 1st squad navy", "279th kiap 2nd squad navy",
				"standard-1 navy", "standard-2 navy"
			}, -- liveries for ["countries"][1]
		}
	}, -- end of [36]
	[37] = {
		["type"] = "Su-34",
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}",
				}, -- end of [7]
				[8] = 
				{
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
				}, -- end of [8]
				[9] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [9]
				[10] = 
				{
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
				}, -- end of [10]
				[11] = 
				{
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
				}, -- end of [11]
				[12] = 
				{
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
				}, -- end of [12]
			}, -- end of ["pylons"]
			["fuel"] = "9800",
			["flare"] = 64,
			["chaff"] = 64,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
		},
		["liveries"] = { 
			[1] = { "af standard", "af standard 2" }, -- liveries for ["countries"][1]
		}
	}, -- end of [37]
	[38] = {
		["type"] = "C-101CC",
		["active"] = true,
		["speed"] = {200,400},
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [3]
				[4] = 
				{
					["CLSID"] = "{AN-M3}",
				}, -- end of [4]
				[5] = 
				{
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
				}, -- end of [5]
				[6] = 
				{
					["CLSID"] = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}",
				}, -- end of [6]
				[7] = 
				{
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
				}, -- end of [7]
			}, -- end of ["pylons"]
			["fuel"] = 1683,
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.SPAIN,
		},
		["liveries"] = { 
			[1] = { "CLAEX Desert Camu Skin - Centro Logistico de Armamento y Experimentacion", "CLAEX Green Camu Skin - Centro Logistico de Armamento y Experimentacion","Aviodev Skin" }, -- liveries for ["countries"][1]
		}
	}, --end of [38]
} -- end of RTFighters
RTTransport = {


	[1] = {
		["type"] = "C-17A",
		["active"] = true,
		["speed"] = {150,440},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "132405",
			["flare"] = 60,
			["chaff"] = 120,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA
		},
		["liveries"] = { 
			[1] = { "usaf standard" } -- liveries for ["countries"][1]
		}
	}, -- end of [1]
	[2] = {
		["type"] = "C-130",
		["active"] = true,
		["speed"] = {150,290},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "45922",
			["flare"] = 60,
			["chaff"] = 120,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.BELGIUM,
			[3] = country.id.DENMARK,
			[4] = country.id.FRANCE,
			[5] = country.id.UK,
			[6] = country.id.ISRAEL,
			[7] = country.id.CANADA,
			[8] = country.id.THE_NETHERLANDS,
			[9] = country.id.NORWAY,
			[10] = country.id.SPAIN,
			[11] = country.id.TURKEY
		},
		["liveries"] = { 
			[1] = { "US Air Force" }, -- liveries for ["countries"][1]
			[2] = { "Belgian Air Force" }, -- liveries for ["countries"][2]
			[3] = { "Royal Danish Air Force" }, -- liveries for ["countries"][3]
			[4] = { "French Air Force" }, -- liveries for ["countries"][4]
			[5] = { "Royal Air Force" }, -- liveries for ["countries"][5]
			[6] = { "Israel Defence Force" }, -- liveries for ["countries"][6]
			[7] = { "Canada's Air Force" }, -- liveries for ["countries"][7]
			[8] = { "Royal Netherlands Air Force" }, -- liveries for ["countries"][8]
			[9] = { "Royal Norwegian Air Force" }, -- liveries for ["countries"][9]
			[10] = { "Spanish Air Force" }, -- liveries for ["countries"][10]
			[11] = { "Turkish Air Force" } -- liveries for ["countries"][11]
		}
	}, -- end of [2]
	[3] = {
		["type"] = "E-2D",
		["active"] = true,
		["speed"] = {110,320},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "12399",
			["flare"] = 60,
			["chaff"] = 120,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA
		},
		["liveries"] = { 
			[1] = { "E-2D Demo", "VAW-125 Tigertails" } -- liveries for ["countries"][1]
		}
	}, -- end of [3]
	[4] = {
		["type"] = "E-3A",
		["active"] = true,
		["speed"] = {150,430},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "143300",
			["flare"] = 60,
			["chaff"] = 120,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.FRANCE,
			[3] = country.id.UK
		},
		["liveries"] = { 
			[1] = { "nato", "usaf standard" }, -- liveries for ["countries"][1]
			[2] = { "nato" }, -- liveries for ["countries"][2]
			[3] = { "nato" }, -- liveries for ["countries"][3]
		}
	}, -- end of [4]
	[5] = {
		["type"] = "KC-135",
		["active"] = true,
		["speed"] = {150,290},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "199959",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA
		},
		["liveries"] = { 
			[1] = { "Standard USAF" } -- liveries for ["countries"][1]
		}
	}, -- end of [5]
	[6] = {
		["type"] = "MQ-1A Predator",
		["active"] = true,
		["speed"] = {70,107},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "441",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA
		},
		["liveries"] = { 
			[1] = { "USAF Standard" } -- liveries for ["countries"][1]
		}
	}, -- end of [6]
	[7] = {
		["type"] = "MQ-9 Reaper",
		["active"] = true,
		["speed"] = {100,200},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "2866",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,
			[2] = country.id.FRANCE,
			[3] = country.id.ITALY,
			[4] = country.id.UK
		},
		["liveries"] = { 
			[1] = { "'camo' scheme", "standard" }, -- liveries for ["countries"][1]
			[2] = { "standard France" }, -- liveries for ["countries"][2]
			[3] = { "standard Italy" }, -- liveries for ["countries"][3]
			[4] = { "standard UK" }, -- liveries for ["countries"][4]
		}
	}, -- end of [7]
	[8] = {
		["type"] = "S-3B Tanker",
		["active"] = true,
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "12125",
			["flare"] = 30,
			["chaff"] = 30,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA,			
		},
		["liveries"] = { 
			[1] = { "NAVY Standard" } -- liveries for ["countries"][1]
		}
	}, -- end of [8]
	[9] = {
		["type"] = "A-50",
		["active"] = true,
		["speed"] = {130,400},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "154324",
			["flare"] = 192,
			["chaff"] = 192,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,			
		},
		["liveries"] = { 
			[1] = { "RF Air Force", "RF Air Force New" } -- liveries for ["countries"][1]
		}
	}, -- end of [9]
	[10] = {
		["type"] = "An-26B",
		["active"] = true,
		["speed"] = {110,300},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "12125",
			["flare"] = 384,
			["chaff"] = 384,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2]	= country.id.ABKHAZIA,			
			[3] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "RF Air Force" }, -- liveries for ["countries"][1]
			[2] = { "Abkhazian AF" }, -- liveries for ["countries"][2]
			[3] = { "Ukraine AF" }, -- liveries for ["countries"][3]
		}
	}, -- end of [10]
	[11] = {
		["type"] = "An-26B",
		["active"] = true,
		["speed"] = {110,300},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "12125",
			["flare"] = 384,
			["chaff"] = 384,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.GEORGIA
		},
		["liveries"] = { 
			[1] = { "Georgian AF" }, -- liveries for ["countries"][1]
		}
	}, -- end of [11]
	[12] = {
		["type"] = "An-30M",
		["active"] = true,
		["speed"] = {110,270},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "18298",
			["flare"] = 192,
			["chaff"] = 192,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,			
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "RF Air Force" }, -- liveries for ["countries"][1]
			[2] = { "15th Transport AB" }, -- liveries for ["countries"][2]
		}
	}, -- end of [12]
	[13] = {
		["type"] = "IL-76MD",
		["active"] = true,
		["speed"] = {120,430},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "176370",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.CHINA,
			[3] = country.id.UKRAINE,
		},
		["liveries"] = { 
			[1] = { "RF Air Force" }, -- liveries for ["countries"][1]
			[2] = { "China Air Force New", "China Air Force Old" }, -- liveries for ["countries"][2]
			[3] = { "Ukrainian AF", "Ukrainian AF aeroflot" }, -- liveries for ["countries"][3]
		}
	}, -- end of [13]
	[14] = {
		["type"] = "IL-78M",
		["active"] = true,
		["speed"] = {120,430},
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "198416",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
		},
		["liveries"] = { 
			[1] = { "RF Air Force", "RF Air Force aeroflot", "RF Air Force new" }, -- liveries for ["countries"][1]
		}
	}, -- end of [14]
} -- end of RTTransport
RTBombers = {
	[1] = {
		["type"] = "B-52H",
		["active"] = true,
		["speed"] = {200,500},
		["payload"] = {
			["pylons"] =
			{
				[1] =
				{
					["CLSID"] = "{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}",
				}, -- end of [1]
				[3] =
				{
					["CLSID"] = "{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}",
				}, -- end of [3]
			}, -- end of ["pylons"]
			["fuel"] = "141135",
			["flare"] = 192,
			["chaff"] = 1125,
			["gun"] = 100,
		}, -- end of ["payload"]		
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA
		},
		["liveries"] = { 
			[1] = { "usaf standard" }, -- liveries for ["countries"][1]
		}		
	}, -- end of [1]
	[2] = {
		["type"] = "B-1B",
		["active"] = true,
		["speed"] = {160,700},
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "MK_82*28",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "MK_82*28",
				}, -- end of [2]
				[3] = 
				{
					["CLSID"] = "MK_82*28",
				}, -- end of [3]
			}, -- end of ["pylons"]
			["fuel"] = "88450",
			["flare"] = 30,
			["chaff"] = 60,
			["gun"] = 100,
		}, -- end of ["payload"]		
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA
		},
		["liveries"] = { 
			[1] = { "usaf standard" }, -- liveries for ["countries"][1]
		}		
	}, -- end of [2]
	[3] = {
		["type"] = "F-117A",
		["speed"] = {170,600},
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
				}, -- end of [2]
			}, -- end of ["pylons"]
			["fuel"] = "3840",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
		}, -- end of ["payload"]		
		["coalition"] = coalition.side.BLUE,
		["countries"] = { 
			[1] = country.id.USA
		},
		["liveries"] = { 
			[1] = { "usaf standard" }, -- liveries for ["countries"][1]
		}		
	}, -- end of [3]
	[4] = {
		["type"] = "Tu-160",
		["active"] = true,
		["speed"] = {170,600},
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{0290F5DE-014A-4BB1-9843-D717749B1DED}",
				}, -- end of [1]
				[2] = 
				{
					["CLSID"] = "{0290F5DE-014A-4BB1-9843-D717749B1DED}",
				}, -- end of [2]
			}, -- end of ["pylons"]
			["fuel"] = "157000",
			["flare"] = 72,
			["chaff"] = 72,
			["gun"] = 100,
		}, -- end of ["payload"]	
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
		}		
	}, -- end of [4]
	[5] = {
		["type"] = "Tu-22M3",
		["speed"] = {170,600},
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{12429ECF-03F0-4DF6-BCBD-5D38B6343DE1}",
				}, -- end of [1]
				[5] = 
				{
					["CLSID"] = "{12429ECF-03F0-4DF6-BCBD-5D38B6343DE1}",
				}, -- end of [5]
			}, -- end of ["pylons"]
			["fuel"] = "50000",
			["flare"] = 48,
			["chaff"] = 48,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}		
	}, -- end of [5]
	[6] = {
		["type"] = "Tu-95MS",
		["active"] = true,
		["speed"] = {170,600},
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{0290F5DE-014A-4BB1-9843-D717749B1DED}",
				}, -- end of [1]
			}, -- end of ["pylons"]
			["fuel"] = "87000",
			["flare"] = 48,
			["chaff"] = 48,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
			[2] = country.id.UKRAINE
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
			[2] = { "af standard" }, -- liveries for ["countries"][2]
		}		
	}, -- end of [6]
	[7] = {
		["type"] = "Tu-142",
		["speed"] = {170,600},
		["active"] = true,
		["payload"] = 
		{
			["pylons"] = 
			{
				[1] = 
				{
					["CLSID"] = "{C42EE4C3-355C-4B83-8B22-B39430B8F4AE}",
				}, -- end of [1]
			}, -- end of ["pylons"]
			["fuel"] = "87000",
			["flare"] = 48,
			["chaff"] = 48,
			["gun"] = 100,
		}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA,
		},
		["liveries"] = { 
			[1] = { "af standard" }, -- liveries for ["countries"][1]
		}		
	}, -- end of [7]
} -- end of RTBombers
RTCivilian = {
	[1] = {
		["type"] = "Yak-40",
		["active"] = true,
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "3080",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
			}, -- end of ["payload"]
		["coalition"] = coalition.side.NEUTRAL,
		["countries"] = { 
			[1] = country.id.INSURGENTS
		},
		["liveries"] = { 
			[1] = { "Georgian Airlines", "Aeroflot", "Olympic Airways", "Ukranian" } -- liveries for ["countries"][1]
		}
	}, -- end of [1]
	[2] = {
		["type"] = "IL-76MD",
		["active"] = true,
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "176370",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
			}, -- end of ["payload"]
		["coalition"] = coalition.side.RED,
		["countries"] = { 
			[1] = country.id.RUSSIA
		},
		["liveries"] = { 
			[1] = { "FSB aeroflot" } -- liveries for ["countries"][1]
		}
	}, -- end of [2]
	[3] = {
		["type"] = "IL-76MD",
		["active"] = true,
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "176370",
			["flare"] = 96,
			["chaff"] = 96,
			["gun"] = 100,
			}, -- end of ["payload"]
		["coalition"] = coalition.side.NEUTRAL,
		["countries"] = { 
			[1] = country.id.INSURGENTS
		},
		["liveries"] = { 
			[1] = { "MVD aeroflot" } -- liveries for ["countries"][1]
		}
	}, -- end of [3]
	[4] = {
		["type"] = "An-26B",
		["active"] = true,
		["payload"] = {
			["pylons"] =
			{
			}, -- end of ["pylons"]
			["fuel"] = "12125",
			["flare"] = 0,
			["chaff"] = 0,
			["gun"] = 100,
			}, -- end of ["payload"]
		["coalition"] = coalition.side.NEUTRAL,
		["countries"] = { 
			[1] = country.id.INSURGENTS
		},
		["liveries"] = { 
			[1] = { "Aeroflot" } -- liveries for ["countries"][1]
		}
	}, -- end of [4]
} -- end of RTCivilian

DTS = {}

local function tableContainsValue(tbl,val)
	for i,v in ipairs(tbl)
	do
		if v == val
		then						
			return true
		end
	end
	
	return false
end

local function tableConcat(tbl1,tbl2)
	local tbl = {}
	for i=1,#tbl1
	do
		tbl[#tbl+1] = tbl1[i]
	end
	for i=1,#tbl2
	do
		tbl[#tbl+1] = tbl2[i]
	end
	return tbl
end

local function getDistance(x1,z1,x2,z2)
	local v1 = x1-x2
	local v2 = z1-z2
	local distance = math.sqrt(v1^2+v2^2)
	return distance
end

local function getAirbase(coa, player)

	pos = player:getPosition()
	rvals = {}
	local airdromes = {}
	local tmp = coalition.getAirbases(coa)
	tmp = tableConcat(tmp,coalition.getAirbases(0))
	for i=1,#tmp do
		local j = #airdromes + 1
		airdromes[j] = {}
		airdromes[j].coa = coa
		airdromes[j].name = tmp[i]:getName()
		airdromes[j].pos = {}
		local pos2  = tmp[i]:getPosition()
		airdromes[j].dist = getDistance(pos.p.x,pos.p.z,pos2.p.x,pos2.p.z)
		airdromes[j].pos = pos2
	end
		local function tsort(a1,a2)
		return a1.dist < a2.dist
	end
	
	if #airdromes > 1 then
		table.sort(airdromes,tsort)
	end
	
	--local airbasetableprintout = mist.utils.tableShow(airdromes)
	--trigger.action.outText("This is how the table looks like: \n\n"..airbasetableprintout , 10)
	
	if #airdromes > 0 then
		return  airdromes
	else
		return nil
	end	
end -- end of getAirbase

DTS.Init = function()
	DTS.groups = {}
	DTS.counter = {
		["medium"] = 0,
		["low"] = 0,
		["contrail"] = 0
	}


	List_AngleLow = {
		Aircraft = {},
		FlightSize = DTSConf_AngleLow_FlightSize,
		Altitude = DTSConf_AngleLow_Altitude,
		AltType = DTSConf_AltitudeType,
		Speed = DTSConf_AngleLow_Speed,
		Active = false,

		}	
		
	List_AngleMedium = {
		Aircraft = {},
		FlightSize = DTSConf_AngleMedium_FlightSize,
		Altitude = DTSConf_AngleMedium_Altitude,
		AltType = DTSConf_AltitudeType,
		Speed = DTSConf_AngleMedium_Speed,
		Active = false,

		}	
		
	List_AngleContrail = {
		Aircraft = {},
		FlightSize = DTSConf_AngleContrail_FlightSize,
		Altitude = DTSConf_AngleContrail_Altitude,
		AltType = DTSConf_AngleContrail_AltitudeType,
		Speed = DTSConf_AngleContrail_Speed,
		Active = false,

		}

	DTS.Countries = {}
	DTS.Countries.RED = {}
	DTS.Countries.BLUE = {}

	for name,index in pairs(country.id)
	do
		if coalition.getCountryCoalition(index) == coalition.side.RED
		then
			DTS.Countries.RED[#DTS.Countries.RED+1] = index
		end
		
		if coalition.getCountryCoalition(index) == coalition.side.BLUE		
		then
			DTS.Countries.BLUE[#DTS.Countries.BLUE+1] = index
		end
	end	
		
		
		
	local _fixedWing = 	tableConcat(RTTransport, RTFighters)
	_fixedWing =  tableConcat(_fixedWing,RTBombers)
	_fixedWing = tableConcat(_fixedWing,RTCivilian)
		
	for i=#_fixedWing,1,-1
	do
		local _dump = _fixedWing[i]
		if tableContainsValue(DTS_FixedWing_Low, _dump["type"])
		then
			List_AngleLow.Aircraft[#List_AngleLow.Aircraft+1] = _dump
		end
		
		if tableContainsValue(DTS_FixedWing_Medium, _dump["type"])
		then
			List_AngleMedium.Aircraft[#List_AngleMedium.Aircraft+1] = _dump
		end
		
		if tableContainsValue(DTS_FixedWing_Contrail, _dump["type"])
		then
			List_AngleContrail.Aircraft[#List_AngleContrail.Aircraft+1] = _dump
		end
		
	end
	if _debug then
		trigger.action.outText("DTS initialized!" , 10)
	end
	
	--local airbasetableprintout = mist.utils.tableShow(List_AngleLow)
	--trigger.action.outText("This is how the table looks like: \n\n"..airbasetableprintout , 10)
	
end -- end of DTS.init

DTS.SpawnAircraft = function (coal, angle, spawn_pos, waypoint_pos)
	local _craft = {}
	local _units = {}
	local data = {}
	local _cIndex = 0
	local _liveryId = 0
--if true then
	

	if angle == "medium" 
	then
		_craft = List_AngleMedium.Aircraft[math.random(#List_AngleMedium.Aircraft)]
		_alti = math.random(List_AngleMedium.Altitude[1],List_AngleMedium.Altitude[2])
		_AltType = List_AngleMedium.AltType
		
		
		if _craft.speed then
			_speed = math.random(_craft.speed[1], _craft.speed[2])
		else
			_speed = math.random(List_AngleMedium.Speed[1],List_AngleMedium.Speed[2])
		end
		_flightSize = List_AngleMedium.FlightSize
	 
	elseif angle == "low" 
	then
		_craft = List_AngleLow.Aircraft[math.random(#List_AngleLow.Aircraft)]
		_alti = math.random(List_AngleLow.Altitude[1],List_AngleLow.Altitude[2])
		_AltType = List_AngleLow.AltType
		
		if _craft.speed then
			_speed = math.random(_craft.speed[1], _craft.speed[2])
		else
			_speed = math.random(List_AngleLow.Speed[1],List_AngleLow.Speed[2])
		end
		_flightSize = List_AngleLow.FlightSize
		

		
	 elseif angle == "contrail"
	 then
		_craft = List_AngleContrail.Aircraft[math.random(#List_AngleContrail.Aircraft)]
		_alti = math.random(List_AngleContrail.Altitude[1],List_AngleContrail.Altitude[2])
		_AltType = List_AngleContrail.AltType
		
		if _craft.speed then
			_speed = math.random(_craft.speed[1], _craft.speed[2])
		else
			_speed = math.random(List_AngleContrail.Speed[1],List_AngleContrail.Speed[2])
		end
		_flightSize = List_AngleContrail.FlightSize
	 else
		trigger.action.outText("Wrong parameter" , 10)
		
	end
	 
	--get country and skin
	_cIndex = math.random(#_craft["countries"])
	_liveryId = _craft["liveries"][_cIndex][math.random(#_craft["liveries"][_cIndex])]
	_hdg = math.random(0,360)
	-- spawn position
	 --local spawn_pos_x = spawn_pos["x"]
	 --local spawn_pos_y = spawn_pos["z"]
	 
	 -- create first waypoint	
	 local _waypoints = {}
	 _waypoints[#_waypoints+1] = {
		["alt"] = _alti,
		["type"] = "Turning Point",
		["action"] = "Turning Point",
		["alt_type"] = _AltType,
		["formation_template"] = "",
		["properties"] = 
		{
			["vnav"] = 1,
			["scale"] = 0,
			["angle"] = 0,
			["vangle"] = 0,
			["steer"] = 2,
		}, -- end of ["properties"]
		["ETA"] = 0,
		["ETA_locked"] = true,
		["y"] = spawn_pos["z"], -- !! 
		["x"] = spawn_pos["x"],
		["speed"] = _speed,
		["speed_locked"] = true,
		["task"] = 
		{
			["id"] = "ComboTask",
			["params"] = 
			{
				["tasks"] = 
				{
					[1] = 
					{
						["enabled"] = true,
						["auto"] = false,
						["id"] = "Orbit",
						["number"] = 1,
						["params"] = 
						{
							["altitude"] = _alti,
							["pattern"] = "Race-Track",
							["speed"] = _speed,
						}, -- end of ["params"]
					}, -- end of [1]
				}, -- end of ["tasks"]
			}, -- end of ["params"]
		}, -- end of ["task"]
	}

	-- 5. create second waypoint
	_waypoints[#_waypoints+1] = {
		["alt"] = _alti,
		["type"] = "Turning Point",
		["action"] = "Turning Point",
		["alt_type"] = _AltType,
		["formation_template"] = "",
		["properties"] = 
		{
			["vnav"] = 1,
			["scale"] = 0,
			["angle"] = 0,
			["vangle"] = 0,
			["steer"] = 2,
		}, -- end of ["properties"]
		["ETA"] = 0,
		["ETA_locked"] = false,
		["y"] = waypoint_pos["z"],
		["x"] = waypoint_pos["x"],
		["speed"] = _speed,
		["speed_locked"] = true,
		["task"] =  {
			["id"] = "ComboTask",
			["params"] = {
				["tasks"] = {							   
				}, -- end of ["tasks"]
			}, -- end of ["params"]
		}, -- end of ["task"]
	}
	 
	--local airbasetableprintout = mist.utils.tableShow(_waypoints[2])
	--trigger.action.outText("This is how the table looks like: \n\n"..airbasetableprintout , 10)
	 
	 for i=1,_flightSize,1
	 do
		_units[i] = {
			["alt"] = _waypoints[1].alt,
			["heading"] = _hdg,
			["livery_id"] = _liveryId,
			["type"] = _craft["type"],
			["psi"] = 0,
			["onboard_num"] = 10 + i,
			["y"] = _waypoints[1].y + 50*(i-1),
			["x"] = _waypoints[1].x + 50*(i-1),
			["name"] =  "DTS_Unit" .. "" ..angle.."" .. math.random(9999,99999),
			["payload"] = _craft["payload"],
			["speed"] = _waypoints[1].speed,
			["unitId"] =  math.random(9999,99999),
			["alt_type"] = _waypoints[1].alt_type,
			["skill"] = "Excellent",
		} -- end of _units
	 end -- end of for

		data = {
			["modulation"] = 0,
			["tasks"] = {},
			["task"] = "CAS",
			["uncontrolled"] = false,
			["route"] = {
				["points"] = _waypoints
						}, -- end of ["route"]
			["groupId"] = math.random(99,999),
			["hidden"] = false,
			["units"] = _units,
			["y"] = _waypoints[1].y,
			["x"] = _waypoints[1].x,
			["name"] =  "DTS_Group"..""..angle..""..math.random(9999,99999),
			["communication"] = true,
			["start_time"] = 0,
			["frequency"] = 124
		} -- end of data

	 if (coal == coalition.side.RED)
	 then
		coalition.addGroup(DTS.Countries.RED[math.random(#DTS.Countries.RED)], Group.Category.AIRPLANE, data)
	 elseif (coal == coalition.side.BLUE)
	 then
		coalition.addGroup(DTS.Countries.BLUE[math.random(#DTS.Countries.BLUE)], Group.Category.AIRPLANE, data)
	 end
	
	DTS.groups[#DTS.groups+1]={
		id = data["groupId"],
		name = data["name"],
		units = data["units"],
		angle = angle
		}
	DTS.counter[angle] = DTS.counter[angle]+1
	
	--local airbasetableprintout = mist.utils.tableShow(DTS.groups)
	--trigger.action.outText("This is how the table looks like: \n\n"..airbasetableprintout , 10)
--else
	--trigger.action.outText("To much aircrafts spawned already", 10)
--end -- end of first if
	
end -- end of DTS.SpawnAircraft

DTS.RemoveGroups = function()
	local player = world:getPlayer()
	local player_pos = player:getPosition()
	groups = DTS.groups
	--local airbasetableprintout = mist.utils.tableShow(groups)
	--trigger.action.outText("This is how the table looks like: \n\n"..airbasetableprintout , 10)
	for i=1,#groups,1 do
		local units = groups[i].units
		for i=1,#units,1 do
			local name = units[i]["name"]
			local unit = Unit.getByName(name)
			local pos2 = unit:getPosition(self)
			if player_pos and pos2 then
			units[i].dist = getDistance(player_pos.p.x,player_pos.p.z,pos2.p.x,pos2.p.z)
			else
				trigger.action.outText("Can't get positions", 10)
			end
		end	
			local function tsort(a1,a2)
				return a1.dist < a2.dist
			end
			
			if #units > 1 then
				table.sort(units,tsort)
			end
		if groups[i].units[1].dist > DTSConf_DeleteDist then
			local group = Group.getByName(groups[i].name)
			Group.destroy(group)
			if _debug then
				trigger.action.outText("Group "..groups[i].name .. " deleted!" , 10)
			end
			DTS.counter[groups[i].angle] = DTS.counter[groups[i].angle]-1
			table.remove(DTS.groups,i)
			break
		else
		--do nothing
		end
	end -- end if (groups)
end -- end of DTS.RemoveGroups

DTS.TraficPopUp = function()
	 -- get nearest airfields 
	 -- get spawn position
	 -- get destination position (airfield)
	 -- call spwan.aircraft
	local player = world:getPlayer()
	if player then
		local _wpPos = {}
		local coa = player:getCoalition() -- überprüfen s.u.
		local _airdromes = getAirbase (coa,player)
		for i=#_airdromes,1,-1 do
			local _dist = _airdromes[i]["dist"]
							
			if _dist < DTSConf_Aktivation_Distance then
				local _pos = _airdromes[i]["pos"]["p"]
				local _coa = _airdromes[i]["coa"] -- vielleicht doppelt zu oben???
				
					--local airbasetableprintout = mist.utils.tableShow(DTS.counter)
					--trigger.action.outText("This is how the table looks like: \n\n"..airbasetableprintout , 10)
				temp = {"medium","low","contrail"}
				for j=1,#temp do
						
						local max_groups = DTS_TraficIntensity[temp[j]]
						--trigger.action.outText("Maximum off groups spawn\n"..max_groups , 10)
						
					if DTS.counter[temp[j]] < max_groups then
						local radius = DTSConf_Spawn_Radius
						local _posVar_x = math.random(-radius,radius) -- variability
						local _posVar_y = math.random(-radius,radius)
				
						if _pos then
							_pos["x"] = _pos["x"] + _posVar_x
							_pos["z"] = _pos["z"] + _posVar_y
						else
						trigger.action.outText("Not getting position", 10)
						end
						
						local a = math.random(1,#_airdromes)
						if a~=i then
							_wpPos = _airdromes[a]["pos"]["p"]
								 
								--trigger.action.outText("a>0: a="..a.." Airdromes: "..#_airdromes, 10)
							
						else
							_wpPos = _airdromes[math.floor(#_airdromes/2)]["pos"]["p"]
								
								--trigger.action.outText("a="..a.." Airdromes: "..#_airdromes, 10)
						end
						DTS.SpawnAircraft(_coa,temp[j],_pos,_wpPos)
						
						if _debug then
						 trigger.action.outText("Group "..temp[j].." at ".._airdromes[i].name.." spawned! Dest: x: ".._wpPos["x"].."\n y: ".._wpPos["z"], 10)
						end
						
					end --for if
				end -- for j
				
			else
			--trigger.action.outText("No near Airfield"..i, 10)
			--do nothing
			end -- end of if
		end --end of for
	else
		trigger.action.outText("No player existing!", 10)
	end	-- end of if
 end -- end of traficPopUp
 
 
 -- Main Programm
DTS.Init()
mist.scheduleFunction(DTS.TraficPopUp,{},timer.getTime() + 1,2)
mist.scheduleFunction(DTS.RemoveGroups,{},timer.getTime() + 1,10)

end